﻿<%@ CODEPAGE=65001 %> 
<%
' Replace the above line with your localized code page number
'------------------------------------------------------------
'
' Microsoft Internet Printing Project
'
' Copyright (c) Microsoft Corporation. All rights reserved.
'
'------------------------------------------------------------
    option explicit

%>
<!-- #include file = "ipp_util.inc" -->
<%
    Const L_OpenPrinter_Text = "プリンタを開く"    
 	
    CheckSession
    Response.Expires = 0

    Dim strPrinter, strComputer, objQueue, objJobs, strAction, iRes
    Dim objPrinter

    On Error Resume Next
    Err.Clear

    strPrinter = Request("eprinter")
    if Len(strPrinter) > MAX_ENCODED_PRINTER_NAME_LENGTH Then
        Call ErrorHandler(L_InvalidParameter_Text)
    Else
        strPrinter = OleCvt.DecodeUnicodeName(strPrinter)
    End If

    strComputer = Session(COMPUTER)
    Set objQueue = GetObject("WinNT://" & strComputer & "/" & strPrinter & ",PrintQueue")
    Set objJobs = objQueue.PrintJobs

    Set objPrinter = Server.CreateObject(PROGID_HELPER)
    objPrinter.open "\\" & strComputer & "\" & strPrinter
    If Err Then
        Call ErrorHandler (L_OpenPrinter_Text)
    End If

Function isSupported(bSupported)
    Const L_Supported_Text = "サポートされています"
    Const L_Unsupported_Text = "サポートされていません"
    If bSupported = 1 Then
        isSupported = L_Supported_Text
    Else
        isSupported = L_Unsupported_Text
    End If
End Function

    Dim strTitle
    Const L_Title_Text = "<title>%2 上の %1 のプリンタ プロパティ</title>"
    strTitle = RepString2(L_Title_Text, strCleanString(strPrinter), session(LOCAL_SERVER))

%>
<html>

<head>
<%=SetCodePage%>
<meta http-equiv="refresh" content="30">
<% =Write (strTitle) %>
</head>


<%
Function GetString (str)

    If str = "" Then
        GetString = "&nbsp;"
    Else
        GetString = strCleanString (str)
    End If
End Function

Function GenPropertyTable (objQueue, objPrinter)
    Dim strHTML
    Dim strBgnCol1, strBgnCol2, strEndCol
    Dim strBgnRow, strEndRow
    Dim strTmp, strUnit
    Dim strUrl
    Dim i, arrayNameList, iUnit

    Const L_PrinterModel_Text = "プリンタ モデル:"
    Const L_Status_Text       = "状態:"
    Const L_Location_Text     = "場所:"
    Const L_Comment_Text      = "コメント:"
    Const L_Url_Text          = "ネットワーク名:"
    Const L_Jobs_Text         = "ドキュメント:"
    Const L_Speed_Text        = "速度:"
    Const L_BgnSpeed_Text     = ""
    Const L_Duplex_Text       = "両面印刷:"
    Const L_Color_Text        = "色:"
    Const L_Resolution_Text   = "最高解像度:"

    strHTML = ""

    strBgnCol1 = "<tr><td width=""138"" valign=""top"">" & DEF_FONT_TAG & "<b>"
    strBgnCol2 = "</b>" & END_FONT & "</td><td>" & DEF_FONT_TAG
    strEndCol  = END_FONT & "</td></tr>"

    strHTML = strHTML & strBgnCol1 & L_PrinterModel_Text & strBgnCol2 & GetString(objQueue.model) & strEndCol
    strHTML = strHTML & strBgnCol1 & L_Location_Text & strBgnCol2 & _
              GetString (objQueue.Location) & strEndCol 
    strHTML = strHTML & strBgnCol1 & L_Comment_Text & strBgnCol2 & _
              GetString (objQueue.Description) & strEndCol 

    If Request.ServerVariables("HTTPS") = "off" Then
        strUrl = "http://"
    Else
        strUrl = "https://"
    End If

    strUrl = GetString(strUrl & session(LOCAL_SERVER) & "/printers/" & GetFriendlyName (objQueue.Printerpath, strComputer) & "/.printer")

    strHTML = strHTML & strBgnCol1 & L_Url_Text & strBgnCol2 & strUrl & strEndCol 
    strHTML = strHTML & strBgnCol1 & L_Jobs_Text & strBgnCol2 & objQueue.JobCount & strEndCol

    On Error Resume Next
    Err.Clear

    iUnit = objPrinter.PageRateUnit
    If Err.Number = 0 Then
        strTmp = objPrinter.PageRate
        If Err.Number = 0 And strTmp <> "0" Then
            Const L_PPM_Text = " PPM (ページ数/分)"
            Const L_CPS_Text = " CPS (文字数/秒)"
            Const L_LPM_Text = " LPM (行数/分)"
            Const L_IPM_Text = " IPM (インチ数/分)"

            Select Case iUnit
            Case 1
                strUnit = L_PPM_Text
            Case 2
                strUnit = L_CPS_Text
            Case 3
                strUnit = L_LPM_Text
            Case 4
                strUnit = L_IPM_Text
            End Select

            strHTML = strHTML & strBgnCol1 & L_Speed_Text & L_BgnSpeed_Text & strBgnCol2 & strTmp & strUnit & strEndCol
        End If
    End If
    Err.Clear

    strTmp = objPrinter.Color
    If Err.Number = 0 Then
        strHTML = strHTML & strBgnCol1 & L_Color_Text & strBgnCol2 & isSupported (strTmp) & strEndCol
    End If
    Err.Clear


    strTmp = objPrinter.Duplex
    If Err.Number = 0 Then
        strHTML = strHTML & strBgnCol1 & L_Duplex_Text & strBgnCol2 & isSupported (strTmp) & strEndCol 
    End If
    Err.Clear

    strTmp = objPrinter.MaximumResolution
    If Err.Number = 0 Then
        Const L_DPI_Text = " DPI (ドット/インチ)"
        strHTML = strHTML & strBgnCol1 & L_Resolution_Text & strBgnCol2 & strTmp & L_DPI_Text & strEndCol 
    End If

    GenPropertyTable = strHTML

End Function
%>

<body bgcolor="#FFFFFF" text="#000000" link="#000000" vlink="#000000" alink="#000000"
topmargin="0" leftmargin="0">

<table border="0" cellpadding="2" cellspacing="0" width="100%">
<%=Write (GenPropertyTable (objQueue, objPrinter))%>
</table>

<%
    objPrinter.close
%>

</body>
</html>