﻿<%@ CODEPAGE=65001 %>
<%
' Replace the above line with your localized code page number
'------------------------------------------------------------
'
'   Microsoft Internet Printing Project
'
'   Copyright (c) Microsoft Corporation 1998
'
'   Printer Job List
'
'------------------------------------------------------------
    Option Explicit
%>
<!-- #include file = "ipp_util.inc" -->
<%
    Const CHECKED_TAG           = " checked "   
 
    Randomize
    CheckSession
    Response.Expires = 0
    Const SelectedColor = "#c0c0c0"
    Const UnselectedColor = "#ffffff"
    Const iJobLength = 10
    Const L_OpenQueue_Text = "キューを開く"
    Const L_GetJobs_Text   = "ジョブを取得する"

    Dim strPrinter, strAction, strComputer, strJobid, objQueue, objJobs, objJob, iRes, bDHTML
    Dim objPrinter
    Dim iStart, iEnd

    Dim index

    index = -1

    strPrinter = Request("eprinter")
    if Len(strPrinter) > MAX_ENCODED_PRINTER_NAME_LENGTH Then
        Call ErrorHandler(L_InvalidParameter_Text)
    Else
        strPrinter = OleCvt.DecodeUnicodeName(strPrinter)
    End If

    strAction = Request("action")
    strJobid = Request("jobid")
    strComputer = Session(COMPUTER)
    bDHTML = Session(DHTML_ENABLED)

    On Error Resume Next
    Err.Clear

    If Request("startid") = "" Or Request ("endid") = "" Then
        iStart = 1
        iEnd = iStart+ iJobLength
    Else
        iStart = Int (Request ("startid"))
        iEnd = Int (Request ("endid"))
    End If

    Set objQueue = GetObject("WinNT://" & strComputer & "/" & strPrinter & ",PrintQueue")
    If Err Then ErrorHandler (L_OpenQueue_Text)
    Set objJobs = objQueue.PrintJobs
    If Err Then ErrorHandler (L_GetJobs_Text)

Function strJobStatus(iStatus)
    Dim L_JobStatus_Text(11)
    Dim bit, i
    Dim strTemp, bFirst
    Const L_Seperator_Text = " - "

    L_JobStatus_Text(0) = "一時停止"
    L_JobStatus_Text(1) = "エラー"
    L_JobStatus_Text(2) = "削除中"
    L_JobStatus_Text(3) = "スプール中"
    L_JobStatus_Text(4) = "印刷中"
    L_JobStatus_Text(5) = "オフライン"
    L_JobStatus_Text(6) = "用紙切れ"
    L_JobStatus_Text(7) = "印刷完了"
    L_JobStatus_Text(8) = "削除済み"
    L_JobStatus_Text(9) = "ブロックされました"
    L_JobStatus_Text(10) = "要調査"
    L_JobStatus_Text(11) = "再起動中"

    bit = 1
    i = 0

    bFirst = True
    strTemp = ""

    For i = 0 To 11
        If iStatus And bit Then
            If Not bFirst Then
                strTemp = strTemp + L_Seperator_Text
            End If
                strTemp = strTemp + L_JobStatus_Text(i)
                bFirst = False
        End If
        bit = bit * 2
    Next
    If strTemp = "" Then strTemp = "&nbsp;"

    strJobStatus = strTemp
End Function

Function GenQueueViewHead ()
    Dim L_TableHeader1_Text, L_TableHeader2_Text, L_TableHeader3_Text
    Dim L_TableHeader4_Text, L_TableHeader5_Text, L_TableHeader6_Text

    L_TableHeader1_Text =  "<b>ドキュメント</b>"
    L_TableHeader2_Text = "<b>状態</b>"
    L_TableHeader3_Text = "<b>所有者</b>"
    L_TableHeader4_Text = "<b>ページ数</b>"
    L_TableHeader5_Text = "<b>サイズ</b>"
    L_TableHeader6_Text = "<b>受け付け時刻</b>"

    GenQueueViewHead = "<tr>"  & _
                        "<td width=""30%"" bgcolor=""#000000"" nowrap>" & MENU_FONT_TAG & L_TableHeader1_Text & END_FONT & "</td>" &_
                        "<td width=""10%"" bgcolor=""#000000"" nowrap>" & MENU_FONT_TAG & L_TableHeader2_Text & END_FONT & "</td>" &_
                        "<td width=""10%"" bgcolor=""#000000"" nowrap>" & MENU_FONT_TAG & L_TableHeader3_Text & END_FONT & "</td>" &_
                        "<td width=""10%"" bgcolor=""#000000"" nowrap>" & MENU_FONT_TAG & L_TableHeader4_Text & END_FONT & "</td>" &_
                        "<td width=""10%"" bgcolor=""#000000"" nowrap>" & MENU_FONT_TAG & L_TableHeader5_Text & END_FONT & "</td>" &_
                        "<td width=""20%"" bgcolor=""#000000"" nowrap>" & MENU_FONT_TAG & L_TableHeader6_Text & END_FONT & "</td>" &_
                        "</tr>"
End Function

Function GenQueueViewBody (objJob, i)
    Dim strHTML
    Dim TdStart, TdEnd
    
    TdStart = "<td nowrap>" & DEF_FONT_TAG
    TdEnd = END_FONT & "</td>"

    If objJob.Name = strJobid Then
        index = i
    End If

    strHTML = strHTML & "<tr bgcolor=" & UnselectedColor & " id=" & (i-1) & ">" &_
              TdStart & "&nbsp;<input type=radio name=jobid value=""" & objJob.name & """"

    If objJob.name = strJobid Then
        strHTML = strHTML & CHECKED_TAG
    End If

    strHTML = strHTML & ONCLICK_EQUALS & """return setJobId(" & objJob.name & ");"">" &_
              strCleanString (objjob.Description) & TdEnd &_
              TdStart & strJobStatus(objJob.status) & TdEnd &_
              TdStart & objJob.user & TdEnd

    If objJob.totalpages > 0 Then
        strHTML = strHTML & TdStart & objJob.totalpages & TdEnd
    Else
        strHTML = strHTML & TdStart & "&nbsp;" & TdEnd
    End If

    If objJob.size > 0 Then
        strHTML = strHTML & TdStart & strFormatJobSize (objJob.size) & TdEnd
    Else
        strHTML = strHTML & TdStart & "&nbsp;" & TdEnd
    End If

    strHTML = strHTML & TdStart & formatdatetime(objJob.timesubmitted, 3) & " " &_
              formatdatetime(objJob.timesubmitted, 2) & TdEnd & "</tr>"
    GenQueueViewBody = strHTML

End Function

%>
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">
<html>

<head>
<meta http-equiv="refresh" content="30">
<%=SetCodePage%>
<title><%=Write (L_DocumentList_Text)%></title>
</head>

<body bgcolor="#FFFFFF" text="#000000" topmargin="0" leftmargin="0" link="#000000"
vlink="#000000" alink="#000000">

<script language="javascript">
function setJobId (id)
{
    document.forms[1].elements[0].value = id;
    return true;
}
</script>


<form>
<%if bDHTML then %>
  <div
  ONCLICK="colorSelector()"><script LANGUAGE="JavaScript">
	var oldTr = 0;
	function colorSelector() {
		var jlist = document.all.JOBLIST.rows;
		
		if (!jlist[0].contains (event.srcElement)) {

			if (oldTr != null) {
				oldTr.bgColor = "<%=UnselectedColor%>";
			}

			for (i = 1; i < jlist.length; i++) {
				if (jlist[i].contains (event.srcElement)) {
					oldTr = jlist[i];
					oldTr.bgColor = "<%=SelectedColor%>";
					document.forms[0].elements[oldTr.id - <%=iStart%> + 1].checked = true;
					setJobId (document.forms[0].elements[oldTr.id - <%=iStart%> + 1].value);
				}
			}
		}
	}

</script>
<% end if%>

<table id="JOBLIST" border="0" cellpadding="2" cellspacing="0" width="100%">
    <%= Write (GenQueueViewHead) %>
<%
	Dim i
    Dim bShowNext
    bShowNext = FALSE
	i = 1

	For Each objJob In objJobs
        If (i >= iEnd) Then
            bShowNext = TRUE
            Exit For
        End If

        If (i >= istart) Then
            Response.Write (Write (GenQueueViewBody (objJob, i)))
            'Response.Write (GenQueueViewBody (objJob, i))
        End If
        i = i + 1
    Next

%>
</table>
</form>

<form >
  <input type="hidden" name="selectedid" value="<%=strJobid%>">
  <input type="hidden" name="startid" value="<%=iStart%>">
  <input type="hidden" name="endid" value="<%=iEnd%>">
</form>


<%
    If i = 1 Then 'No job in the printer queue
        Const L_NoJob_Text = "<br><br><center><b>プリンタ キューにドキュメントがありません</b></center>"
        Response.Write (Write(DEF_FONT_TAG & L_NoJob_Text & END_FONT))
    End If

    Dim strUrl
    const L_Prev_Text = "前の %1 ドキュメント"
    Const L_Next_Text = "次の %1 ドキュメント"

    strUrl = "<a target=""_top"" href=ipp_0004.asp?eprinter=" & Request("eprinter") & VIEW_EQUALS & Request("view") & "&startid=" & CStr(iStart - iJobLength) & "&endid=" & CStr(iEnd - iJobLength) & ATPAGE & CStr(Int(Rnd*10000)) & ">" &_
             RepString1(L_Prev_Text, CStr (iJobLength)) & "</a>&nbsp;&nbsp;&nbsp;&nbsp;"

    If iStart > 1 Then
        Response.Write ( Write(DEF_FONT_TAG & strUrl & END_FONT))
    End If

    strUrl = "<a target=""_top"" href=ipp_0004.asp?eprinter=" & Request("eprinter") & VIEW_EQUALS & Request("view") & "&startid=" & CStr(iStart + iJobLength) & "&endid=" & CStr(iEnd+iJobLength) & ATPAGE & CStr(Int(Rnd*10000)) & ">" &_
             RepString1(L_Next_Text, CStr (iJobLength)) & "</a>"

    If bShowNext Then
        Response.Write ( Write(DEF_FONT_TAG & strUrl & END_FONT))
    End If

%>


<%if bDHTML then%>
  </div>
<% end if %>
<%if index > 0 then%>
<script LANGUAGE="JavaScript">

	window.onerror=windowError;
	function windowError ()
	{	return true; }

	if (document.all) {
        oldTr = document.all.JOBLIST.rows[<%=index - iStart + 1%>];
        oldTr.bgColor = "<%=SelectedColor%>";
    }
</script>
<%end if%>

</body>
</html>