@echo off
setlocal

REM *** Update HKCU for current user
call :CreateKeys "HKCU"

REM *** Update HKCU for all other users
cd /D %USERPROFILE%\..
for /f "tokens=*" %%i in ('dir /b /ad') do (
    if exist ".\%%i\NTUSER.DAT" call :CreateKeysForOtherUser "%%i" ".\%%i\NTUSER.DAT" HKLM\TempHive
)

endlocal

goto :EOF

REM *** 
REM *** Args: %1 = username; %2 = name of registry hive file for user; %3 = location to load user hive to
REM *** Precondition: %keybase% has key (excluding GUID)
REM *** Ignores hives for current user (which should be updated directly with CreateKeys to prevent multiple access problems)
REM *** Ignores "All Users" and system service accounts which are irrelevant for our purposes
REM *** 
:CreateKeysForOtherUser
set fUpdateUser=Y
if /I %1 equ "All Users" set fUpdateUser=N
if /I %1 equ "LocalService" set fUpdateUser=N
if /I %1 equ "NetworkService" set fUpdateUser=N
if /I %1 equ "%USERNAME%" set fUpdateUser=N

if %fUpdateUser% equ Y (
    %SystemRoot%\system32\reg.exe load %3 %2 >nul 2>&1
    call :CreateKeys %3
    %SystemRoot%\system32\reg.exe unload %3 >nul 2>&1
)

goto :EOF

REM *** 
REM *** Args: %1 = hive
REM *** Precondition: proper hive is loaded (if necessary)
REM *** 
:CreateKeys
set keybase=Software\Microsoft\Windows\CurrentVersion\Ext\Settings
for %%i in ({9059f30f-4eb1-4bd2-9fdc-36f43a218f4a}
            {7584c670-2274-4efb-b00b-d6aaba6d3850}
            {4EDCB26C-D24C-4e72-AF07-B576699AC0DE}
            {4eb89ff4-7f78-4a0f-8b8d-2bf02e94e4b2}
            {7390f3d8-0439-4c05-91e3-cf5cb290c3d0}) do (
    %SystemRoot%\system32\reg.exe add "%1\%keybase%\%%i" /v Flags /d 0x1 /t REG_DWORD /f >nul
    %SystemRoot%\system32\reg.exe add "%1\%keybase%\%%i" /v Version /d "*" /t REG_SZ /f >nul
)

set keybase=Software\Microsoft\Windows\CurrentVersion\Ext\Stats
for %%i in ({9059f30f-4eb1-4bd2-9fdc-36f43a218f4a}
            {7584c670-2274-4efb-b00b-d6aaba6d3850}
            {4EDCB26C-D24C-4e72-AF07-B576699AC0DE}
            {4eb89ff4-7f78-4a0f-8b8d-2bf02e94e4b2}
            {7390f3d8-0439-4c05-91e3-cf5cb290c3d0}) do (
    %SystemRoot%\system32\reg.exe add "%1\%keybase%\%%i\iexplore" /v Flags /d 0x4 /t REG_DWORD /f >nul
)


goto :EOF
