' Script to look for all possible MSTSC product codes installed on machine, and if found
' to uninstall them.
' 3/7/2006
' a-paulhi

Option Explicit

' Target MSI product codes for the WinXP platform install
Dim ProductCodes(141)
' WinXP
ProductCodes(0) = "{3E713D52-C967-41FB-AA24-3A92CC1025A4}"      ' LangCode = 1033, en-us
ProductCodes(1) = "{4DEEE869-7CA9-48C9-B219-105DF2BE3D6B}"      ' LangCode = 1040, it-it
ProductCodes(2) = "{60B9A48D-559E-43FA-8F28-D657190E4E52}"      ' LangCode = 1033, en-us
ProductCodes(3) = "{62416B78-C0F2-46ED-963C-F38064F7F0DB}"	    ' LangCode = 1033, en-us
ProductCodes(4) = "{62C4121D-CA64-413E-8444-0525FF7E8EF9}"	    ' LangCode = 1031, de-de
ProductCodes(5) = "{82217086-FCE7-41F8-8512-77C42583DB69}"	    ' LangCode = 1043, nl-nl
ProductCodes(6) = "{ACC2D401-9724-415D-BDA4-D2E96C650648}"	    ' LangCode = 1044, no-no
ProductCodes(7) = "{D81A311F-D26B-4BDA-8A44-0B608DF49BEF}"	    ' LangCode = 2052, zh-cn
ProductCodes(8) = "{DDB41B52-55BB-47DE-ADBC-057A466DC1CA}"	    ' LangCode = 1030, da
' WinXP SP1
ProductCodes(9) = "{048C1B35-1B4D-4524-8D80-407CD00C9402}"      ' LangCode = 1036, fr-fr
ProductCodes(10) = "{188D0CE7-A37B-4495-B501-AEA2BA048D87}"     ' LangCode = 1055, tr
ProductCodes(11) = "{19BD26B5-9947-475A-984F-40BC0D83C3C3}"     ' LangCode = 1033, en-us
ProductCodes(12) = "{2F7E500B-ADD4-4088-AC7A-6C29B3D1B56B}"     ' LangCode = 2052, zh-cn
ProductCodes(13) = "{45F2A1EA-3967-4D7C-9AA2-0E24AAD6A40C}"     ' LangCode = 2070, pt-pt
ProductCodes(14) = "{4B3E6767-2BCC-4790-9CFF-38CB88337FA9}"     ' LangCode = 1046, pt-br
ProductCodes(15) = "{4C099CB3-E0E4-45BB-9C60-B1193CA47638}"     ' LangCode = 1042, ko
ProductCodes(16) = "{60B9A48D-559E-43FA-8F28-D657190E4E52}"     ' LangCode = 1033, en-us (ar, he)
ProductCodes(17) = "{69A0ACF7-8FFC-47D0-94E4-B6844AB23FC3}"     ' LangCode = 1049, ru
ProductCodes(18) = "{73EF628D-0D47-4DC9-841E-E65A9EF56BCD}"     ' LangCode = 1045, pl
ProductCodes(19) = "{77BF3069-851C-4DAC-8507-844E91826133}"     ' LangCode = 1029, cs
ProductCodes(20) = "{7EB86FD8-065B-46F2-8D1C-8A6CD77011AE}"     ' LangCode = 1041, ja
ProductCodes(21) = "{82AE5DA6-4D28-40C2-BF21-9F2B90EF488E}"     ' LangCode = 1033, en-us
ProductCodes(22) = "{8CBB3FAD-D1DE-4B40-B82D-C8913DE4AFEC}"     ' LangCode = 1043, nl-nl
ProductCodes(23) = "{8D97DFD0-90C0-4C02-ACD6-18C6222122D0}"     ' LangCode = 1038, hu
ProductCodes(24) = "{9C40734E-C106-43B3-BB50-4FFB8EF33C93}"     ' LangCode = 1053, sv-se
ProductCodes(25) = "{A1B14276-72BF-4865-8E70-827010E2DDF8}"     ' LangCode = 1040, it-it
ProductCodes(26) = "{ACC2D401-9724-415D-BDA4-D2E96C650648}"     ' LangCode = 1044, no-no
ProductCodes(27) = "{ACE34BA8-D212-48DB-B1E0-5E05271707F2}"     ' LangCode = 1028, zh-tw
ProductCodes(28) = "{C7A35E42-3957-4523-B793-39B92D7E4C77}"     ' LangCode = 1028, zh-tw
ProductCodes(29) = "{D6E11E91-AF22-4454-9665-0BBD1C110305}"     ' LangCode = 1031, de-de
ProductCodes(30) = "{D81A311F-D26B-4BDA-8A44-0B608DF49BEF}"     ' LangCode = 1035, fi (el, fi)
ProductCodes(31) = "{DDB41B52-55BB-47DE-ADBC-057A466DC1CA}"     ' LangCode = 1030, da
ProductCodes(32) = "{FB3E28CA-C097-40B4-A3BD-77CACF43A1DE}"     ' LangCode = 3082, es-es
' WinXP SP2
ProductCodes(33) = "{0E31FAD5-5F2E-40B3-ABAF-086AECECD3A1}"	    ' LangCode = 1033, en-us
ProductCodes(34) = "{1A145C39-5344-4FBC-BD65-2C178D782405}"     ' LangCode = 1046, pt-br
ProductCodes(35) = "{25DB82FC-E42D-4D79-B25D-93CC8B3C83DC}"     ' LangCode = 2070, pt-pt
ProductCodes(36) = "{3E713D52-C967-41FB-AA24-3A92CC1025A4}"     ' LangCode = 1033, en-us
ProductCodes(37) = "{50DE22EF-E283-4BA5-A499-98DEB34648C0}"     ' LangCode = 1049, ru
ProductCodes(38) = "{53FED547-6089-48E0-A640-5B1A87323F88}"     ' LangCode = 2052, zh-cn
ProductCodes(39) = "{549511D0-E5AF-4049-95F4-F233AF7E5253}"     ' LangCode = 1042, ko
ProductCodes(40) = "{5C6B4358-4EBF-43AE-9C74-76690CB4172F}"     ' LangCode = 1036, fr-fr
ProductCodes(41) = "{60B9A48D-559E-43FA-8F28-D657190E4E52}"     ' LangCode = 1033, en-us (ar, he)
ProductCodes(42) = "{62C4121D-CA64-413E-8444-0525FF7E8EF9}"     ' LangCode = 1031, de-de
ProductCodes(43) = "{65DF3237-1232-467E-8C47-5B9A582996E4}"     ' LangCode = 1043, nl-nl
ProductCodes(44) = "{671464CD-07BC-409A-995C-6E537F3F0568}"     ' LangCode = 1041, ja
ProductCodes(45) = "{76DA003B-CBCF-4756-84F3-BB605CB0238A}"     ' LangCode = 1045, pl
ProductCodes(46) = "{7B5870F5-304F-49E4-9B81-7451C0E595F0}"     ' LangCode = 3082, es-es
ProductCodes(47) = "{81610BE6-BF0B-42C2-BB9C-B7D1084290FA}"     ' LangCode = 1040, it-it
ProductCodes(48) = "{A4C8D492-AB9A-41A0-AF8C-9C2769DD1E6D}"     ' LangCode = 1053, sv-se
ProductCodes(49) = "{ACC2D401-9724-415D-BDA4-D2E96C650648}"     ' LangCode = 1044, no-no
ProductCodes(50) = "{AE9F5CF9-8539-4D80-B2ED-65A3D8ABFB52}"     ' LangCode = 1055, tr
ProductCodes(51) = "{B21A1FAD-9060-43BD-85EF-89F26DBDDB4A}"     ' LangCode = 1029, cs
ProductCodes(52) = "{C4EE1A62-C412-4B4D-816D-061128B5381B}"     ' LangCode = 1038, hu
ProductCodes(53) = "{D81A311F-D26B-4BDA-8A44-0B608DF49BEF}"     ' LangCode = 1035, fi (el, fi)
ProductCodes(54) = "{DDB41B52-55BB-47DE-ADBC-057A466DC1CA}"     ' LangCode = 1030, da
ProductCodes(55) = "{FC1C1D59-0E56-4C4B-80B2-A36B603EF64E}"     ' LangCode = 1028, zh-tw
' Win2K3
ProductCodes(56) = "{0CCE003B-FB12-4E31-AAE1-AF1EEA173373}"     ' LangCode = 1045, pl
ProductCodes(57) = "{0E6993D3-4445-4B76-BEAE-917070BB4B7B}"     ' LangCode = 1043, nl-nl
ProductCodes(58) = "{116BB940-46EE-4452-8B5D-F552B9B710F6}"	    ' LangCode = 2052, zh-cn (simple)
ProductCodes(59) = "{28881FE9-F071-4E91-9056-A3D44D1A71E7}"	    ' LangCode = 1053, sv-se
ProductCodes(60) = "{35D027A4-57BA-4E59-94DB-DFB36FFFDC1E}"	    ' LangCode = 1033, en-us
ProductCodes(61) = "{483336E5-6C6E-481B-8F7D-DFDFB614C3D6}"	    ' LangCode = 3082, es-es
ProductCodes(62) = "{48A33815-DA40-4929-B665-FB14FA88D84B}"	    ' LangCode = 2070, pt-pt
ProductCodes(63) = "{4A206C4A-1D17-453C-8FEC-9F3BD8ABF05D}"	    ' LangCode = 1055, tr
ProductCodes(64) = "{52657E64-5500-44E9-BEF9-4BB2F706C168}"	    ' LangCode = 1038, hu
ProductCodes(65) = "{533EC88C-E3EC-46E2-86A5-4F40B7322C50}"	    ' LangCode = 1033, en-us
ProductCodes(66) = "{68C334F5-ECF8-4799-B0D8-1EA7C7E2FD5E}"	    ' LangCode = 1033, en-us
ProductCodes(67) = "{7279FE8E-B3C5-4858-9AB2-B72DCD7145DA}"	    ' LangCode = 1046, pt-br
ProductCodes(68) = "{80CA330E-0432-443B-8698-5AAC53882C36}"	    ' LangCode = 1042, ko
ProductCodes(69) = "{86B7355A-4160-45D6-89EA-E57F9A422ABD}" 	' LangCode = 1036, fr-fr
ProductCodes(70) = "{961B8EA6-AA4E-44B3-94B1-8AE34D06B414}"	    ' LangCode = 1031, de-de
ProductCodes(71) = "{A3AE4DE4-E2A3-452B-A249-47586EEE45CF}"	    ' LangCode = 1049, ru
ProductCodes(72) = "{BBD0063D-2177-4C67-9987-AC1D646A31EE}"	    ' LangCode = 1029, cs
ProductCodes(73) = "{C854EEAE-02A0-4849-B24B-FD3E6B213098}"	    ' LangCode = 1041, ja
ProductCodes(74) = "{D08BCAA5-6F87-455A-80FC-B46B9F90C0F9}"	    ' LangCode = 1033, en-us
ProductCodes(75) = "{D65D9BE2-EB8B-4267-AF18-07E93DFB8CBE}"	    ' LangCode = 1033, en-us
ProductCodes(76) = "{D67D66A7-7A12-487F-BE94-71CD0EFA58E3}"	    ' LangCode = 1033, en-us
ProductCodes(77) = "{DA1CF98B-D338-4BB6-B15F-80A1E87FF823}"	    ' LangCode = 1028, sz-tw (traditional, PanChin)
ProductCodes(78) = "{E0A75FC0-D531-4530-965D-6B66914A46F6}"	    ' LangCode = 1033, en-us
ProductCodes(79) = "{E3CCAB4C-108B-4D9E-A5B0-A24921DB1C42}"	    ' LangCode = 1033, en-us
ProductCodes(80) = "{F91CD0F6-D045-44F3-834E-38FA844A8F2F}"	    ' LangCode = 1028, sz_tw (traditional, TradChin)
ProductCodes(81) = "{FCF4B77A-9D90-4A47-8FE5-FF2B3D2F1CE5}"	    ' LangCode = 1040, it-it
' Win2K3 SP1
ProductCodes(82) = "{1006255F-12EF-4B8C-96A1-6969555AEC12}"     ' LangCode = 1029, cs
ProductCodes(83) = "{37A63585-68A9-479E-886C-7AF839DDDDEE}"     ' LangCode = 1031, de-de
ProductCodes(84) = "{40D658EE-6524-4E59-BF40-8D3E89C17F30}"     ' LangCode = 1053, sv-se
ProductCodes(85) = "{4DAE7947-672B-47D9-B4EE-71B5CC1ECF30}"     ' LangCode = 1055, tr
ProductCodes(86) = "{5231FF0F-1DB0-4EFE-985F-BE640A9A6A2F}"     ' LangCode = 1043, nl-nl
ProductCodes(87) = "{53B054FD-6037-4832-8DC8-1E8584D3215A}"     ' LangCode = 1041, ja
ProductCodes(88) = "{574FFAFD-F176-4807-BE0B-6B4278C2C630}"     ' LangCode = 1046, pt-br
ProductCodes(89) = "{5944D41A-1902-4CC4-B454-4FD74958B684}"     ' LangCode = 2070, pt-pt
ProductCodes(90) = "{59C98CDB-5699-4F8F-92C9-DB70C33A9B57}"     ' LangCode = 1036, fr-fr
ProductCodes(91) = "{5F2E4735-52F1-457B-8CF4-C226FE790B90}"     ' LangCode = 1042, ko
ProductCodes(92) = "{7BC66CD9-E8A2-4CBA-AA23-E837529EE494}"     ' LangCode = 1045, pl
ProductCodes(93) = "{832AC8C9-0BEF-4167-BEE9-4E84C338E3EF}"     ' LangCode = 1049, ru
ProductCodes(94) = "{84A622C4-03A3-44FC-AB1A-99F44C317E5A}"     ' LangCode = 2052, zh-cn
ProductCodes(95) = "{8D45A40C-3EB0-42B4-B827-61DF6A9E5DB9}"     ' LangCode = 1028, zh-tw
ProductCodes(96) = "{9CE1CB00-FE6A-4364-913E-959E222B9526}"     ' LangCode = 1028, zh-tw
ProductCodes(97) = "{A1E8F8D3-CB6B-43F4-B716-D9086204B0D9}"     ' LangCode = 1038, hu
ProductCodes(98) = "{AFB5847C-242F-428C-BBD9-BD4311818CF9}"     ' LangCode = 1040, it-it
ProductCodes(99) = "{B7F39004-BA30-4235-A4ED-A65CFC727D61}"     ' LangCode = 3082, es-es
ProductCodes(100) = "{D08BCAA5-6F87-455A-80FC-B46B9F90C0F9}"	' LangCode = 1033, en-us
ProductCodes(101) = "{F874A799-5EF4-42C4-BE1C-F90D260A109F}"    ' LangCode = 1033, en-us
' More WinXP SP2 Codes
ProductCodes(102) = "{0829EBD7-B354-4308-9500-26A9F5BAB37C}"     ' LangCode = 1028
ProductCodes(103) = "{104180F4-719E-44E8-B86F-F7B9F3EBD5C2}"     ' LangCode = 1033
ProductCodes(104) = "{36A28C49-B51E-4A1B-BDE4-3016259834A0}"     ' LangCode = 2052
ProductCodes(105) = "{695E8231-32BD-4139-B502-7B35F286E8F6}"     ' LangCode = 1040
ProductCodes(106) = "{7CDD6357-CB43-4830-8D2C-152AEE98088B}"     ' LangCode = 1029
ProductCodes(107) = "{9A0FEC92-F4C6-4190-B1D1-D52308E58CEF}"     ' LangCode = 1038
ProductCodes(108) = "{9C75D5E7-252D-4CA1-B42F-DF4E83521096}"     ' LangCode = 3082
ProductCodes(109) = "{DD1EE7BA-AF73-4183-8F44-C03F9E613DFC}"     ' LangCode = 1049
ProductCodes(110) = "{50DE22EF-E283-4BA5-A499-98DEB34648C0}"     ' LangCode = 1049
ProductCodes(111) = "{53FED547-6089-48E0-A640-5B1A87323F88}"     ' LangCode = 2052
ProductCodes(112) = "{5DEB2A35-9CDA-49A1-B9AA-D8FE4E5564E0}"     ' LangCode = 1028
ProductCodes(113) = "{806D0202-0F0D-4BA4-B348-448A37319990}"     ' LangCode = 1040
ProductCodes(114) = "{CDA7B0FC-15FB-462F-81E5-473162D05836}"     ' LangCode = 1036
' More Win2K3 SP1 Codes
ProductCodes(115) = "{1F572FD2-85C9-4A3C-9A26-1074AB2AE2BE}"     ' LangCode = 1033
ProductCodes(116) = "{48BC47A4-71D9-4D63-89A9-63E652FD7721}"     ' LangCode = 1055
ProductCodes(117) = "{78FC320F-79A2-41B2-9A18-FFCE786C6E0A}"     ' LangCode = 1033
ProductCodes(118) = "{82D47B86-AA32-4DA1-BAD7-9907659FEA45}"     ' LangCode = 2052
ProductCodes(119) = "{92929B56-2A96-4DAF-A800-85BF73307832}"     ' LangCode = 1028
ProductCodes(120) = "{C166FA8A-69B0-49F3-9CF6-897DBBB369C4}"     ' LangCode = 1041
ProductCodes(121) = "{E3304A54-688B-40C2-88D9-E1F4007790BF}"     ' LangCode = 1033
' Win2K3 SP2 Codes
ProductCodes(122) = "{146D7C06-B88F-45AD-9660-E954FFE2FE3F}"  ' 1033
ProductCodes(123) = "{09E8E1BB-EEF1-4DDC-9E24-B5F24BC8B0F0}"  ' 1028
ProductCodes(124) = "{104E9B18-FD48-454A-B1D9-B63574A762DE}"  ' 1038
ProductCodes(125) = "{180E8FD7-9BED-4128-99F0-74A37B4F229B}"  ' 3082
ProductCodes(126) = "{4248EAB4-5745-40E3-92CF-909EEBD8D126}"  ' 1042
ProductCodes(127) = "{509BC734-3136-4836-8955-2A62545DF48A}"  ' 1043
ProductCodes(128) = "{584F7665-F3CF-4B84-B5F8-8B55C213791F}"  ' 1040
ProductCodes(129) = "{6146425B-8FBE-4505-8F53-497A310DF809}"  ' 1053
ProductCodes(130) = "{6C64E73B-2A43-489E-AF5E-76A178BA187B}"  ' 2052
ProductCodes(131) = "{6F2BC32D-31A7-46AF-969C-705B9499C191}"  ' 1029
ProductCodes(132) = "{82DFC9FD-EE99-421D-AD35-FBA9B610470D}"  ' 1041
ProductCodes(133) = "{8B03AE2F-3EF0-41A2-A8C9-2ADF3F73F31A}"  ' 1045
ProductCodes(134) = "{940FE2D5-5F4B-4D69-8853-626190DB0E9D}"  ' 1031
ProductCodes(135) = "{9DCC5364-DA27-47DE-A3B9-F86AA4ADF04B}"  ' 1049
ProductCodes(136) = "{9FBE8BA5-4819-4E11-A30E-29477E646596}"  ' 1055
ProductCodes(137) = "{AC5A8F36-40CC-4D96-B3CF-C08BD1AEC208}"  ' 1028
ProductCodes(138) = "{C19EDE07-28FD-465C-BA11-8D6109B48265}"  ' 1046
ProductCodes(139) = "{CEA78563-2EC3-4A9E-97B0-A6B65B7EF2B6}"  ' 2070
ProductCodes(140) = "{EEDBB3AA-A432-4F6E-9EE2-8AFCDEB78097}"  ' 1036


On Error Resume Next

' Instantiate Windows Installer object
Dim installer : Set installer = Nothing
Set installer = Wscript.CreateObject("WindowsInstaller.Installer") : CheckError

Dim UILevelNone : UILevelNone = 2       'Silent uninstall
Dim productCode

' Loop through all possible product codes and uninstall if found
For Each productCode In ProductCodes

    Dim localMSIFileName
    Dim dataBaseObj

    Err = 0

    ' Get product information
    localMSIFileName = installer.ProductInfo(productCode, "LocalPackage")
    If (Err = 0) Then
    
        Dim message : message = "Uninstalling: " & localMSIFileName
        WScript.Echo message
        
        ' Uninstall this package
        installer.UILevel = UILevelNone
        installer.InstallProduct localMSIFileName, "REMOVE=ALL" : CheckError1
        
    End If
    
Next

WScript.Echo "Done"


Sub CheckError
	Dim message
	if Err = 0 Then Exit Sub
	message = "Error: " & Err.Source & " " & Hex(Err) & ": " & Err.Description
	WScript.Echo message
	WScript.Quit 1
End Sub

Sub CheckError1
    Dim message
    if Err = 0 Then Exit Sub
    message = "Error: " & Err.Source & " " & Hex(Err) & ": " & Err.Description
    WScript.Echo message
End Sub
