<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
<html>

<head>
	<title><xsl:value-of select="xpnetdiag/title"/></title>
	
	<style type="text/css">
		
	</style>
</head>

<body>
	<font face="arial">
	<xsl:value-of select="xpnetdiag/lastRunText"/>  <xsl:value-of select="xpnetdiag/timeStamp"/>	
	
	<xsl:for-each select="xpnetdiag/component">
		<xsl:sort select="@startDiagnosisTime" order="descending"/>
		<table border="1" width="640">
			<tr bgcolor="#CCCCCC">
				<xsl:value-of select="@name"/>
			</tr>
			
			<tr><td>
			<xsl:for-each select="rootCause">
				<table border="0" width="640">
					<xsl:choose>
						<xsl:when test="@status='confirm'">
							<tr bgcolor="#ee6666">
								<xsl:value-of select="/confirmText"/>  <xsl:value-of select="@name"/>
							</tr>
						</xsl:when>
						<xsl:when test="@status='indeterminate'">
							<tr bgcolor="#8888cc">
								<xsl:value-of select="/indeterminateText"/>  <xsl:value-of select="@name"/>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<tr bgcolor="#88CC88">
								<xsl:value-of select="/rejectText"/>  <xsl:value-of select="@name"/>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
					<tr>
						<xsl:for-each select="trace">
							<tr>
								<td width="60"><xsl:value-of select="@traceType"/></td>
								<td><xsl:value-of select="@text"/></td>
							</tr>
						</xsl:for-each>
					</tr>
				</table>
			</xsl:for-each>
			</td></tr>
		</table>
		<p/>
	</xsl:for-each>
	</font>
</body>


</html>
</xsl:template>
</xsl:stylesheet>