﻿<?xml version='1.0' encoding='utf-8' standalone='yes'?>
<assembly
    xmlns="urn:schemas-microsoft-com:asm.v3"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    authors="michkap"
    buildFilter=""
    company="MSFT"
    copyright=""
    creationTimeStamp="2003-05-21T11:55:23.0000000-07:00"
    description="Time Zones Downlevel Migration"
    displayName="Time zone Downlevel registry entries"
    lastUpdateTimeStamp="2003-05-21T12:18:11.0000000-07:00"
    manifestVersion="1.0"
    owners="michkap"
    supportInformation=""
    testers=""
    >
  <assemblyIdentity
      language="*"
      name="Microsoft-Windows-International-TimeZones-DL"
      processorArchitecture="*"
      version="0.0.0.0"
      />
  <!-- Date/Time control panel downlevel migration manifest -->
  <!-- This specifies the registries to be migrated when upgraded from a downlevel system -->
  <!-- The migration includes: -->
  <!-- Current time zone values: HKLM\SYSTEM\CurrentControlSet\Control\TimeZoneInformation -->
  <!-- Additional customized timezones added by users: HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones - known timezone keys. -->
  <!-- This is generated by mantranslate and then HAND EDITED. -->
  <!-- Commands: ManTranslate.exe /downlevel /log:c:\log %_ntroot%\MergedComponents\cmidata\SharedNlsManifests\Other\International-TimeZones.man %_ntroot%\MergedComponents\cmidata\SharedNlsManifests\Other\International-TimeZones-DL.man -->
  <migration scope="Upgrade,MigWiz,USMT">
    <migXml xmlns="">
      <!-- Migrate per-system data -->
      <!-- Check as this is only valid for down-level OS < than Windows Vista -->
      <detects>
        <detect>
          <condition>MigXmlHelper.IsOSEarlierThan("NT", "6.0.0.0")</condition>
        </detect>
      </detects>
      <rules context="System">
        <include>
          <objectSet>
            <!-- Migrate custom time zone entries.  These are -->
            <!-- This rule will combine with the exclude rule to select all user-created sub keys and their values under Time Zones key -->
            <!-- The include rule will cause all sub-keys and values under Time Zones to be selected. -->
            <!-- The exclude rule will caues all known sub-keys and values to be exclued -->
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\* [TZI]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\* [MUI_Display]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\* [MUI_Dlt]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\* [MUI_Std]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\* [Display]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\* [Dlt]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\* [Std]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\* [IsObsolete]</pattern>
            <!-- Migrate Internet Time Server entries. -->
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\DateTime\Servers\* [*]</pattern>
          </objectSet>
        </include>
        <!-- The exclude rule will caues all known sub-keys and values to be exclued -->
        <exclude>
          <objectSet>
            <!-- No need to migrate the IndexMapping registry value or Index values -->
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones [IndexMapping]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\* [Index]</pattern>
            <!-- List all LH supported timezone here.  We do not need to migrate these since they will be re-created by the registryKeys section -->
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Afghanistan Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Alaskan Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Arab Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Arabian Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Arabic Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Argentina Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Atlantic Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\AUS Central Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\AUS Eastern Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Azerbaijan Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Azores Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Bangladesh Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Canada Central Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Cape Verde Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Caucasus Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Cen. Australia Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Central America Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Central Asia Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Central Brazilian Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Central Europe Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Central European Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Central Pacific Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Central Standard Time (Mexico)\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Central Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\China Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Dateline Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\E. Africa Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\E. Australia Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\E. Europe Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\E. South America Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Eastern Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Egypt Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Ekaterinburg Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Fiji Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\FLE Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Georgian Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\GMT Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Greenland Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Greenwich Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\GTB Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Hawaiian Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\India Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Iran Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Israel Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Jordan Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Kamchatka Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Korea Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Mauritius Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Mexico Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Mexico Standard Time 2\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Mid-Atlantic Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Middle East Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Montevideo Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Morocco Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Mountain Standard Time (Mexico)\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Mountain Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Myanmar Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\N. Central Asia Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Namibia Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Nepal Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\New Zealand Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Newfoundland Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\North Asia East Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\North Asia Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Pacific SA Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Pacific Standard Time (Mexico)\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Pacific Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Pakistan Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Paraguay Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Romance Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Russian Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\SA Eastern Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\SA Pacific Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\SA Western Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Samoa Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\SE Asia Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Singapore Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\South Africa Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Sri Lanka Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Syria Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Taipei Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Tasmania Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Tokyo Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Tonga Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Ulaanbaatar Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\US Eastern Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\US Mountain Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\UTC\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Venezuela Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Vladivostok Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\W. Australia Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\W. Central Africa Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\W. Europe Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\West Asia Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\West Pacific Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Western Brazilian Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\Yakutsk Standard Time\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\UTC-02\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\UTC-11\* [*]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones\UTC+12\* [*]</pattern>
          </objectSet>
        </exclude>
      </rules>
    </migXml>
  </migration>
</assembly>
